/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioSample;
import ddf.minim.AudioSnippet;
import ddf.minim.Minim;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import processing.core.PApplet;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;

public class CrystalCave
extends PApplet {
    float[][] grids = new float[0][0];
    boolean[][][] collisionMap = new boolean[0][0][0];
    int mapW = 300;
    int mapH = 500;
    int bufferWidth = 8;
    int maxR = 15;
    int viewDist = 25;
    int spireNum = 500;
    int collisionDist = 5;
    int mapZ;
    int crystals;
    int prevTime;
    int targetTime = 40;
    int fr = 36;
    int levelNum;
    int ships;
    float viewX = 0.0f;
    float viewY = 0.0f;
    float viewZ = 0.0f;
    float flySpeed = 0.5f;
    float turnSpeed = 0.7f;
    float diveSpeed = 1.7f;
    float camDist = -45.0f;
    float startZoom;
    float noiseScalar = 5.0f;
    float gh;
    float gw;
    float sliceScalar = 5.0f;
    float heightScalar = 2.0f;
    float widthScalar = 1.0f;
    float depthScalar = 1.0f;
    float tilt = 1.5707964f;
    float noiseVal = 1.0f;
    float topBottomDist = 80.0f;
    float maxBrightness = 0.35f;
    float waterLine = 0.0f;
    float levelMultiplier = 1.2f;
    boolean slicedUp;
    boolean moveL;
    boolean moveR;
    boolean moveU;
    boolean moveD;
    boolean shootKey;
    boolean tripleShotKey;
    boolean levelClear;
    boolean gameOver;
    boolean switchUpDown = false;
    boolean paused;
    boolean startScreen = true;
    slice[] slices;
    GL gl;
    GLU glu;
    boolean GLstarted = false;
    int[][] VBO;
    int[][] VBOtop;
    int[][] VBOc;
    FloatBuffer pointBuffer;
    FloatBuffer colorBuffer;
    int pointCount;
    int printout;
    int printoutSkip = 10;
    float aspect;
    float camZ;
    Vector enemies = new Vector();
    int enemyNum = 50;
    boolean askName;
    boolean showScores;
    String url = "http://benhem.com/games/uploads/";
    String scoreName = "";
    Minim minim;
    AudioSample[] soundArray;
    AudioSnippet groove;
    float noiseScale;
    float[][] noiseMap = new float[0][0];
    int powerUpNum = 100;
    Vector powerups = new Vector();
    GLUquadric quadric;
    float shipA = 0.0f;
    float shipTA = 0.0f;
    float shipZA = 0.0f;
    float shipTZA = 0.0f;
    float turnAnimSpeed = 6.0f;
    float diveAnimSpeed = 6.0f;
    shipChunk[] shipChunks;
    float chunkSpin = 5.0f;
    float shipChunkSize = 7.0f;
    float asplodeSpeed = 4.0f;
    int chunkDuration = 40;
    int asplodeTimer;
    boolean asplode;
    int shotDist = 15;
    float shotSpeed = 2.0f;
    int shotDelay = 100;
    int lastShot = 0;
    Vector shots = new Vector();
    Vector bursts = new Vector();
    Vector messages = new Vector();

    public void setup() {
        this.size(800, 300, "processing.opengl.PGraphicsOpenGL");
        this.hint(1);
        this.colorMode(3, 100.0f);
        this.slicedUp = false;
        this.grids = new float[this.mapW][this.mapH];
        this.mapZ = (int)this.topBottomDist;
        this.collisionMap = new boolean[this.mapW][this.mapH][this.mapZ];
        int n = 0;
        while (n < this.mapH) {
            int n2 = 0;
            while (n2 < this.mapW) {
                this.grids[n2][n] = n2 <= this.bufferWidth ? CrystalCave.constrain((float)((float)(this.bufferWidth - n2) + this.random(5.0f)), (float)0.0f, (float)this.maxR) : (n2 >= this.mapW - this.bufferWidth ? CrystalCave.constrain((float)((float)(this.bufferWidth - (this.mapW - n2)) + this.random(5.0f)), (float)0.0f, (float)this.maxR) : 0.0f);
                int n3 = 0;
                while (n3 < this.mapZ) {
                    this.collisionMap[n2][n][n3] = false;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.spireNum) {
            this.drawCircle((int)this.random(this.mapW), (int)this.random(this.mapH), (int)this.random(this.maxR), 1);
            ++n;
        }
        this.getSlices();
        this.startGL();
        this.startMinim();
        this.levelNum = 1;
        this.crystals = 0;
        this.ships = 3;
        this.gameOver = false;
    }

    public void resetGame() {
        this.crystals = 0;
        this.ships = 3;
        this.flySpeed = 0.5f;
        this.turnSpeed = 0.7f;
        this.diveSpeed = 1.7f;
        this.bursts.clear();
        this.shots.clear();
        this.placePowerups();
        this.placeEnemies();
        this.gh = this.height / this.mapH;
        this.gw = this.width / this.mapW;
        this.viewX = this.mapW / 2;
        this.viewY = this.mapH + 30;
        this.viewZ = 0.0f;
        this.asplode = false;
        this.startZoom = 5.0f;
        this.showMessage("Level " + this.levelNum + " - Get ready!", true);
        this.play(5);
    }

    public void softReset() {
        this.bursts.clear();
        this.shots.clear();
        this.placePowerups();
        this.placeEnemies();
        this.gh = this.height / this.mapH;
        this.gw = this.width / this.mapW;
        this.viewX = this.mapW / 2;
        this.viewY = this.mapH + 30;
        this.viewZ = 0.0f;
        this.asplode = false;
        this.startZoom = 5.0f;
        this.showMessage("Level " + this.levelNum + " - Get ready!", true);
        this.play(5);
    }

    public void draw() {
        this.background(0);
        this.callGL();
        if (this.focused) {
            if (this.gameOver) {
                this.score();
            } else if (this.startScreen) {
                this.gl.glPushMatrix();
                this.gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                this.gl.glColor3f(0.9f, 0.9f, 0.9f);
                this.write("Crystal Cave", 0.0f, -100.0f, 10.0f, 1);
                this.write("Ludum dare 2009   ---   ben hemmendinger   ---   benhem.com", 0.0f, -55.0f, 2.0f, 1);
                this.write("Press any key to start", 0.0f, -25.0f, 3.0f, 1);
                this.write("Use ASDW or arrow keys to fly", 0.0f, 20.0f, 2.0f, 1);
                this.write("Press space to shoot", 0.0f, 40.0f, 2.0f, 1);
                this.write("Press R to reset the game", 0.0f, 60.0f, 2.0f, 1);
                this.write("Press P to pause", 0.0f, 80.0f, 2.0f, 1);
                this.write("Press T to reverse the up/down keys", 0.0f, 100.0f, 2.0f, 1);
                this.write("Collect the white crystals!  Shoot the red ones!", 0.0f, 125.0f, 2.0f, 1);
                this.gl.glPopMatrix();
            } else if (this.paused) {
                this.gl.glPushMatrix();
                this.gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                this.gl.glColor3f(0.9f, 0.9f, 0.9f);
                this.write("Crystal Cave", 0.0f, -100.0f, 5.0f, 1);
                this.write("paused - press P to continue", 0.0f, -50.0f, 3.0f, 1);
                this.write("Use ASDW or arrow keys to fly", 0.0f, 0.0f, 2.0f, 1);
                this.write("Press space to shoot", 0.0f, 25.0f, 2.0f, 1);
                this.write("Press R to reset the game", 0.0f, 50.0f, 2.0f, 1);
                this.write("Press P to pause", 0.0f, 75.0f, 2.0f, 1);
                this.write("Press T to reverse the up/down keys", 0.0f, 100.0f, 2.0f, 1);
                this.write("Collect the white crystals!  Shoot the red ones!", 0.0f, 125.0f, 2.0f, 1);
                this.gl.glPopMatrix();
            } else {
                this.frameRate(this.fr);
                if (!this.asplode) {
                    if (this.shootKey) {
                        this.shoot(1);
                    }
                    if (this.tripleShotKey) {
                        this.shoot(3);
                    }
                    this.moveCheck();
                    this.viewY -= this.flySpeed;
                    if (!this.levelClear) {
                        this.collisionTest();
                    }
                }
                this.gl.glPushMatrix();
                this.game();
                this.gl.glPopMatrix();
                this.gl.glDisable(2929);
                this.gl.glColor4f(1.0f, 1.0f, 1.0f, 0.6f);
                this.gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                this.write("Crystals: " + this.crystals, 15 - this.width / 2, 15 - this.height / 2, 2.0f, 0);
                if (this.ships > 0) {
                    this.write("Ships: " + this.ships, this.width / 2 - 15, 15 - this.height / 2, 2.0f, 2);
                } else {
                    this.write("Last ship!", this.width / 2 - 15, 15 - this.height / 2, 2.0f, 2);
                }
                this.updateMessages();
                if (this.random(333.0f) < 1.0f) {
                    this.play(7 + PApplet.parseInt((float)this.random(-1.0f, 3.0f)));
                }
                this.gl.glEnable(2929);
                int n = this.millis() - this.prevTime;
                if (CrystalCave.abs((int)(n - this.targetTime)) > 3) {
                    this.fr = n > this.targetTime ? CrystalCave.constrain((int)(this.fr + 1), (int)1, (int)80) : CrystalCave.constrain((int)(this.fr - 1), (int)1, (int)80);
                }
                this.prevTime = this.millis();
            }
        } else {
            this.gl.glColor3f(0.9f, 0.9f, 0.9f);
            this.gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            this.write("paused -- click to activate", 0.0f, 0.0f, 3.0f, 1);
        }
    }

    public void collisionTest() {
        if (this.viewY < (float)this.mapH && this.collisionMap[CrystalCave.constrain((int)CrystalCave.round((float)this.viewX), (int)0, (int)(this.mapW - 1))][CrystalCave.constrain((int)CrystalCave.round((float)(this.viewY + (float)this.collisionDist)), (int)0, (int)(this.mapH - 1))][CrystalCave.constrain((int)CrystalCave.abs((int)CrystalCave.round((float)this.viewZ)), (int)0, (int)(this.mapZ - 1))]) {
            this.shipAsplode();
        }
    }

    public void game() {
        this.startZoom = this.startZoom > 0.0f ? (this.startZoom -= 0.1f) : 0.0f;
        this.gl.glPushMatrix();
        this.gl.glRotatef(this.tilt * 360.0f / ((float)Math.PI * 2), 1.0f, 0.0f, 0.0f);
        this.gl.glTranslatef(-this.viewX * this.sliceScalar * this.widthScalar, -(this.camDist + this.startZoom) - this.viewY % 1.0f * this.sliceScalar * this.depthScalar, -this.viewZ);
        int n = CrystalCave.constrain((int)((int)this.viewY - this.viewDist), (int)0, (int)(this.slices.length - 1));
        while ((float)n < CrystalCave.constrain((float)(this.viewY + 5.0f), (float)0.0f, (float)(this.slices.length - 1))) {
            this.gl.glPushMatrix();
            this.gl.glRotatef(this.tilt * 360.0f / ((float)Math.PI * 2), -1.0f, 0.0f, 0.0f);
            this.gl.glBindBufferARB(34962, this.VBOc[CrystalCave.constrain((int)(this.viewDist - PApplet.parseInt((float)CrystalCave.abs((float)((float)n - this.viewY)))), (int)0, (int)(this.VBOc.length - 1))][0]);
            this.gl.glColorPointer(4, 5126, 0, 0L);
            this.gl.glBindBufferARB(34962, this.VBO[n][0]);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glDrawArrays(5, 0, this.pointCount);
            this.gl.glBindBufferARB(34962, this.VBOtop[n][0]);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glDrawArrays(5, 0, this.pointCount);
            this.gl.glPopMatrix();
            this.gl.glTranslatef(0.0f, this.sliceScalar * this.depthScalar, 0.0f);
            ++n;
        }
        this.updateShots();
        this.updatePowerups();
        this.updateEnemies();
        this.gl.glPopMatrix();
        this.gl.glTranslatef(0.0f, 0.0f, -(this.camDist - this.startZoom) * this.sliceScalar);
        this.drawShip();
    }

    public void moveCheck() {
        if (this.moveL) {
            this.viewX -= this.turnSpeed;
        }
        if (this.moveR) {
            this.viewX += this.turnSpeed;
        }
        if (this.moveD) {
            this.viewZ += this.diveSpeed;
        }
        if (this.moveU) {
            this.viewZ -= this.diveSpeed;
        }
        if (this.viewY < 0.0f) {
            if (!this.levelClear) {
                this.showMessage("Level " + this.levelNum + " clear!", true);
            }
            this.levelClear = true;
        }
        if (this.viewY < -30.0f) {
            ++this.levelNum;
            this.showMessage("Level " + this.levelNum + " - get ready!", true);
            this.softReset();
            this.flySpeed *= this.levelMultiplier;
            this.turnSpeed *= this.levelMultiplier;
            this.diveSpeed *= this.levelMultiplier;
            this.levelClear = false;
        }
    }

    public void callGL() {
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective(60.0, (double)this.aspect, (double)0.01f, (double)(this.camZ * 10.0f));
        this.glu.gluLookAt(0.0, 0.0, (double)this.camZ, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
    }

    public void startGL() {
        int n;
        int n2;
        if (this.GLstarted) {
            int n3 = 0;
            while (n3 < this.VBO.length) {
                this.gl.glDeleteBuffers(1, this.VBO[n3], 0);
                this.gl.glDeleteBuffers(1, this.VBOtop[n3], 0);
                ++n3;
            }
            n3 = 0;
            while (n3 < this.VBOc.length) {
                this.gl.glDeleteBuffers(1, this.VBOc[n3], 0);
                ++n3;
            }
            this.VBO = null;
            this.VBOtop = null;
            this.VBOc = null;
        } else {
            this.glu = new GLU();
            this.gl = ((PGraphicsOpenGL)this.g).gl;
            this.gl.glEnableClientState(32884);
            this.gl.glEnableClientState(32886);
            this.quadric = this.glu.gluNewQuadric();
            this.glu.gluQuadricDrawStyle(this.quadric, 100012);
            this.glu.gluQuadricNormals(this.quadric, 100000);
        }
        this.pointCount = this.slices[0].points.length;
        this.aspect = (float)this.width / (float)this.height;
        this.camZ = (float)this.height / 2.0f / CrystalCave.tan((float)0.5235988f);
        this.VBO = new int[this.mapH][1];
        int n4 = 0;
        while (n4 < this.mapH) {
            this.VBO[n4] = new int[1];
            float[] fArray = new float[this.pointCount * 3];
            n2 = 0;
            n = 0;
            while (n2 < this.pointCount) {
                fArray[n] = this.slices[n4].points[n2].x;
                fArray[n + 1] = -this.topBottomDist + this.slices[n4].points[n2].y;
                fArray[n + 2] = 0.0f;
                ++n2;
                n += 3;
            }
            this.pointBuffer = FloatBuffer.wrap(fArray);
            this.gl.glGenBuffersARB(1, this.VBO[n4], 0);
            this.gl.glBindBufferARB(34962, this.VBO[n4][0]);
            this.gl.glBufferDataARB(34962, this.pointBuffer.capacity() * 4, (Buffer)this.pointBuffer, 35044);
            ++n4;
        }
        this.VBOtop = new int[this.mapH][1];
        n4 = 0;
        while (n4 < this.mapH) {
            this.VBOtop[n4] = new int[1];
            float[] fArray = new float[this.pointCount * 3];
            n2 = 0;
            n = 0;
            while (n2 < this.pointCount) {
                fArray[n] = this.slices[n4].points[n2].x;
                fArray[n + 1] = this.topBottomDist - this.slices[n4].points[n2].y;
                fArray[n + 2] = 0.0f;
                ++n2;
                n += 3;
            }
            this.pointBuffer = FloatBuffer.wrap(fArray);
            this.gl.glGenBuffersARB(1, this.VBOtop[n4], 0);
            this.gl.glBindBufferARB(34962, this.VBOtop[n4][0]);
            this.gl.glBufferDataARB(34962, this.pointBuffer.capacity() * 4, (Buffer)this.pointBuffer, 35044);
            ++n4;
        }
        this.VBOc = new int[this.viewDist][1];
        n4 = 0;
        while (n4 < this.viewDist) {
            float f = this.maxBrightness / (float)this.viewDist * (float)n4;
            float[] fArray = new float[this.pointCount * 4];
            n = 0;
            while (n < fArray.length) {
                fArray[n] = n % 4 == 3 ? 1.0f : f;
                ++n;
            }
            this.colorBuffer = FloatBuffer.wrap(fArray);
            this.gl.glGenBuffersARB(1, this.VBOc[n4], 0);
            this.gl.glBindBufferARB(34962, this.VBOc[n4][0]);
            this.gl.glBufferDataARB(34962, this.colorBuffer.capacity() * 5, (Buffer)this.colorBuffer, 35044);
            ++n4;
        }
        this.GLstarted = true;
    }

    public void GLrect(float f, float f2, float f3, float f4) {
        this.gl.glBegin(5);
        this.gl.glVertex3f(f, f2, 0.0f);
        this.gl.glVertex3f(f3, f2, 0.0f);
        this.gl.glVertex3f(f, f4, 0.0f);
        this.gl.glVertex3f(f3, f4, 0.0f);
        this.gl.glEnd();
    }

    public void GLrect(float f, float f2, float f3, float f4, float f5, float f6) {
        this.gl.glBegin(5);
        this.gl.glVertex3f(f, f2, f3);
        this.gl.glVertex3f(f4, f2, f3);
        this.gl.glVertex3f(f, f5, f6);
        this.gl.glVertex3f(f4, f5, f6);
        this.gl.glEnd();
    }

    public void GLdiamond(float f, float f2, float f3) {
        this.gl.glBegin(5);
        this.gl.glVertex3f(f, f2 - f3, 0.0f);
        this.gl.glVertex3f(f + f3, f2, 0.0f);
        this.gl.glVertex3f(f - f3, f2, 0.0f);
        this.gl.glVertex3f(f, f2 + f3, 0.0f);
        this.gl.glEnd();
    }

    public void GLtriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.gl.glBegin(4);
        this.gl.glVertex3f(f, f2, f3);
        this.gl.glVertex3f(f4, f5, f6);
        this.gl.glVertex3f(f7, f8, f9);
        this.gl.glEnd();
    }

    public void updateEnemies() {
        int n = 0;
        while (n < this.enemies.size()) {
            ((enemy)this.enemies.get(n)).update();
            ++n;
        }
    }

    public void placeEnemies() {
        this.enemies.clear();
        while (this.enemies.size() < this.enemyNum) {
            int n;
            int n2;
            int n3 = PApplet.parseInt((float)this.random(this.mapW));
            if (this.collisionMap[n3][n2 = PApplet.parseInt((float)this.random(this.mapH))][CrystalCave.abs((int)(n = PApplet.parseInt((float)this.random(-this.mapZ, this.mapZ))))]) continue;
            this.enemies.add(new enemy(0, n3, n2, n));
        }
    }

    public void score() {
        this.gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
        if (this.askName) {
            this.noStroke();
            this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            this.write("You got a", 0.0f, -35.0f, 2.0f, 1);
            this.write("high score!", 0.0f, -13.0f, 3.0f, 1);
            this.write("Enter your name:", 0.0f, 10.0f, 2.0f, 1);
            this.write(this.scoreName, 0.0f, 32.0f, 2.5f, 1);
        } else if (this.showScores) {
            this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            this.gl.glTranslatef(0.0f, -160.0f, 0.0f);
            String string = "?" + PApplet.parseInt((float)this.random(1000000.0f));
            String[] stringArray = this.loadStrings(String.valueOf(this.url) + "cave/hiscore.txt" + string);
            this.write("HIGH SCORES:", 0.0f, 45.0f, 3.0f, 1);
            this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            int n = 0;
            while (n < CrystalCave.round((float)(stringArray.length / 2))) {
                this.write(stringArray[n], -100.0f, 85 + n * 20, 2.0f, 1);
                ++n;
            }
            n = CrystalCave.round((float)(stringArray.length / 2));
            while (n < stringArray.length) {
                this.write(stringArray[n], 100.0f, 85 + (n - CrystalCave.round((float)(stringArray.length / 2))) * 20, 2.0f, 1);
                ++n;
            }
            this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            this.write("Press R to play again", 0.0f, this.height - 30, 3.0f, 1);
        }
    }

    public void sendName() {
        this.askName = false;
        this.showScores = true;
        this.postScore(this.crystals, this.scoreName);
    }

    public boolean gotHiScore(int n) {
        String string = "?" + PApplet.parseInt((float)this.random(1000000.0f));
        String[] stringArray = this.loadStrings(String.valueOf(this.url) + "cave/hiscore.txt" + string);
        Vector<hiScore> vector = new Vector<hiScore>();
        if (stringArray.length < 18) {
            return true;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            int n3 = string2.lastIndexOf(45, string2.length());
            int n4 = PApplet.parseInt((String)CrystalCave.trim((String)string2.substring(0, n3)));
            String string3 = CrystalCave.trim((String)string2.substring(n3 + 1, string2.length()));
            vector.add(new hiScore(n4, string3));
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            if (((hiScore)vector.get((int)n2)).num < n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void postScore(int n, String string) {
        String string2 = "?" + PApplet.parseInt((float)this.random(1000000.0f));
        String[] stringArray = this.loadStrings(String.valueOf(this.url) + "cave/hiscore.txt" + string2);
        Vector<hiScore> vector = new Vector<hiScore>();
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            int n3 = string3.lastIndexOf(45, string3.length());
            int n4 = PApplet.parseInt((String)CrystalCave.trim((String)string3.substring(0, n3)));
            String string4 = CrystalCave.trim((String)string3.substring(n3 + 1, string3.length()));
            vector.add(new hiScore(n4, string4));
            ++n2;
        }
        vector.add(new hiScore(n, string));
        while (vector.size() > 0) {
            n2 = 0;
            int n5 = 0;
            while (n5 < vector.size()) {
                if (((hiScore)vector.get((int)n5)).num > ((hiScore)vector.get((int)n2)).num) {
                    n2 = n5;
                }
                ++n5;
            }
            vector2.add(vector.get(n2));
            vector.remove(n2);
        }
        stringArray = new String[CrystalCave.min((int)vector2.size(), (int)18)];
        int n6 = 0;
        while (n6 < CrystalCave.min((int)vector2.size(), (int)18)) {
            stringArray[n6] = ((hiScore)vector2.get(n6)).writeLine();
            ++n6;
        }
        this.saveToWeb("hiscore", "txt", "cave", stringArray, false);
    }

    public void saveToWeb(String string, String string2, String string3, String[] stringArray, boolean bl) {
        this.postData(string, string2, string3, CrystalCave.join((String[])stringArray, (String)"\n").getBytes(), bl);
    }

    public void postData(String string, String string2, String string3, byte[] byArray, boolean bl) {
        try {
            URL uRL = new URL(String.valueOf(this.url) + "saveFile.php?title=" + string + "&ext=" + string2 + "&folder=" + string3);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=AXi93A");
            DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
            dataOutputStream.writeBytes("--AXi93A\r\n");
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"data\"; filename=\"whatever\" \r\nContent-Type: image/jpeg\r\nContent-Transfer-Encoding: binary\r\n\r\n");
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeBytes("\r\n--AXi93A--\r\n\r\n");
            dataOutputStream.flush();
            dataOutputStream.close();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    if (string4 != null && bl && string4.substring(0, string3.length()).equals(string3)) {
                        this.link(String.valueOf(this.url) + string4, "_blank");
                    }
                    string4 = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void keyPressed() {
        if (this.key == '3' && !this.online) {
            this.saveFrame("cavern-###.png");
        }
        if (this.startScreen) {
            this.startScreen = false;
            this.resetGame();
        } else if (this.askName) {
            if (this.scoreName.length() > 2 && (this.keyCode == 10 || this.keyCode == 13)) {
                this.sendName();
            } else if (this.keyCode >= 65 && this.keyCode <= 90 && this.scoreName.length() < 13) {
                this.scoreName = String.valueOf(this.scoreName) + PApplet.parseChar((int)this.key);
            } else if (this.keyCode == 32 && this.scoreName.length() < 13) {
                this.scoreName = String.valueOf(this.scoreName) + ' ';
            } else if (this.keyCode == 8 && this.scoreName.length() > 0) {
                this.scoreName = this.scoreName.substring(0, this.scoreName.length() - 1);
            }
        } else {
            switch (this.keyCode) {
                case 37: {
                    this.moveL = true;
                    break;
                }
                case 39: {
                    this.moveR = true;
                    break;
                }
                case 38: {
                    if (this.switchUpDown) {
                        this.moveD = true;
                        break;
                    }
                    this.moveU = true;
                    break;
                }
                case 40: {
                    if (this.switchUpDown) {
                        this.moveU = true;
                        break;
                    }
                    this.moveD = true;
                    break;
                }
                case 65: {
                    this.moveL = true;
                    break;
                }
                case 68: {
                    this.moveR = true;
                    break;
                }
                case 83: {
                    if (this.switchUpDown) {
                        this.moveU = true;
                        break;
                    }
                    this.moveD = true;
                    break;
                }
                case 87: {
                    if (this.switchUpDown) {
                        this.moveD = true;
                        break;
                    }
                    this.moveU = true;
                    break;
                }
                case 32: {
                    this.shootKey = true;
                    break;
                }
                case 70: {
                    this.tripleShotKey = true;
                    break;
                }
                case 82: {
                    this.ships = 3;
                    this.levelNum = 1;
                    this.gameOver = false;
                    this.resetGame();
                    break;
                }
                case 80: {
                    this.paused = !this.paused;
                    break;
                }
                case 84: {
                    boolean bl = this.switchUpDown = !this.switchUpDown;
                    if (this.switchUpDown) {
                        this.showMessage("Up / Down Reversed", true);
                    } else {
                        this.showMessage("Up / Down Normal", true);
                    }
                    this.moveU = false;
                    this.moveD = false;
                }
            }
        }
    }

    public void keyReleased() {
        switch (this.keyCode) {
            case 37: {
                this.moveL = false;
                break;
            }
            case 39: {
                this.moveR = false;
                break;
            }
            case 38: {
                if (this.switchUpDown) {
                    this.moveD = false;
                    break;
                }
                this.moveU = false;
                break;
            }
            case 40: {
                if (this.switchUpDown) {
                    this.moveU = false;
                    break;
                }
                this.moveD = false;
                break;
            }
            case 65: {
                this.moveL = false;
                break;
            }
            case 68: {
                this.moveR = false;
                break;
            }
            case 83: {
                if (this.switchUpDown) {
                    this.moveU = false;
                    break;
                }
                this.moveD = false;
                break;
            }
            case 87: {
                if (this.switchUpDown) {
                    this.moveD = false;
                    break;
                }
                this.moveU = false;
                break;
            }
            case 32: {
                this.shootKey = false;
                break;
            }
            case 70: {
                this.tripleShotKey = false;
            }
        }
    }

    public void startMinim() {
        this.minim = new Minim((PApplet)this);
        this.minim.debugOff();
        this.groove = this.minim.loadSnippet("groove.mp3");
        this.soundArray = new AudioSample[10];
        this.soundArray[0] = this.minim.loadSample("explosion.wav");
        this.soundArray[1] = this.minim.loadSample("laser.wav");
        this.soundArray[2] = this.minim.loadSample("laser2.wav");
        this.soundArray[3] = this.minim.loadSample("crystal.wav");
        this.soundArray[4] = this.minim.loadSample("thud.wav");
        this.soundArray[5] = this.minim.loadSample("approach.wav");
        this.soundArray[6] = this.minim.loadSample("chord.wav");
        this.soundArray[7] = this.minim.loadSample("weird3.wav");
        this.soundArray[8] = this.minim.loadSample("weird2.wav");
        this.soundArray[9] = this.minim.loadSample("weird1.wav");
        this.groove.loop();
    }

    public void play(int n) {
        this.soundArray[n].trigger();
    }

    public void stop() {
        int n = 0;
        while (n < this.soundArray.length) {
            this.soundArray[n].close();
            ++n;
        }
        this.groove.close();
        this.minim.stop();
        super.stop();
    }

    public void getNoiseMap() {
        this.noiseScale = this.random(1000.0f);
        this.noiseMap = new float[this.mapW][this.mapH];
        int n = 0;
        while (n < this.mapH) {
            int n2 = 0;
            while (n2 < this.mapW) {
                this.noiseMap[n2][n] = this.noise((float)n2 * 0.2f + 10.0f + this.noiseScale / 2.0f, (float)n * 0.2f + 10.0f + this.noiseScale / 2.0f, this.noiseScale);
                ++n2;
            }
            ++n;
        }
    }

    public void updatePowerups() {
        int n = 0;
        while (n < this.powerups.size()) {
            ((powerup)this.powerups.get(n)).update();
            ++n;
        }
    }

    public void placePowerups() {
        this.powerups.clear();
        while (this.powerups.size() < this.powerUpNum) {
            int n;
            int n2;
            int n3 = PApplet.parseInt((float)this.random(this.mapW));
            if (this.collisionMap[n3][n2 = PApplet.parseInt((float)this.random(this.mapH))][CrystalCave.abs((int)(n = PApplet.parseInt((float)this.random(-this.mapZ, this.mapZ))))]) continue;
            this.powerups.add(new powerup(0, n3, n2, n));
        }
    }

    public void shipAsplode() {
        this.play(0);
        if (this.ships == 0) {
            this.gameOver = true;
            if (this.gotHiScore(this.crystals)) {
                this.askName = true;
            } else {
                this.showScores = true;
            }
        } else {
            --this.ships;
        }
        this.asplodeTimer = 0;
        this.shipChunks = new shipChunk[50];
        int n = 0;
        while (n < this.shipChunks.length) {
            this.shipChunks[n] = n < 3 ? new shipChunk(0) : (n < 12 ? new shipChunk(1) : new shipChunk(2));
            ++n;
        }
        n = 0;
        while (n < 50) {
            this.bursts.add(new burst(this.viewX * this.sliceScalar * this.widthScalar, 0.0f, this.viewZ, 100, 2.0f));
            ++n;
        }
        this.moveU = false;
        this.asplode = true;
    }

    public void drawShip() {
        this.gl.glPushMatrix();
        if (this.asplode) {
            if (this.asplodeTimer < this.chunkDuration) {
                int n = 0;
                while (n < this.shipChunks.length) {
                    this.shipChunks[n].update();
                    ++n;
                }
                ++this.asplodeTimer;
            } else if (!this.gameOver) {
                this.softReset();
            } else if (this.gameOver) {
                this.showMessage("Game over!  " + this.crystals + " crystals found.  Press R to reset.", true);
            }
        } else {
            this.shipTA = this.moveL != this.moveR ? (this.moveR ? -35.0f : 35.0f) : 0.0f;
            this.shipTZA = this.moveU != this.moveD ? (this.moveU ? -25.0f : 25.0f) : 0.0f;
            if (CrystalCave.abs((float)(this.shipA - this.shipTA)) <= this.turnAnimSpeed) {
                this.shipA = this.shipTA;
            } else if (this.shipA < this.shipTA) {
                this.shipA += this.turnAnimSpeed;
            } else if (this.shipA > this.shipTA) {
                this.shipA -= this.turnAnimSpeed;
            }
            if (CrystalCave.abs((float)(this.shipZA - this.shipTZA)) <= this.diveAnimSpeed) {
                this.shipZA = this.shipTZA;
            } else if (this.shipZA < this.shipTZA) {
                this.shipZA += this.diveAnimSpeed;
            } else if (this.shipZA > this.shipTZA) {
                this.shipZA -= this.diveAnimSpeed;
            }
            this.gl.glRotatef(this.shipA / 2.0f, 0.0f, 0.0f, 1.0f);
            this.gl.glRotatef(this.shipA, 0.0f, 1.0f, 0.0f);
            this.gl.glRotatef(this.shipZA, -1.0f, 0.0f, 0.0f);
            this.gl.glColor3f(0.6f, 0.6f, 0.6f);
            this.GLtriangle(0.0f, 0.0f, 0.0f, -4.0f, -2.0f, 5.0f, 4.0f, -2.0f, 5.0f);
            this.gl.glColor3f(0.4f, 0.4f, 0.4f);
            this.GLrect(-4.0f, -2.0f, 5.0f, 4.0f, -4.0f, 5.0f);
            this.gl.glColor3f(0.0f, 0.5f, 1.0f);
            this.GLrect(-3.0f, -2.5f, 6.0f, -2.0f, -3.5f, 6.0f);
            this.GLrect(-0.5f, -2.5f, 6.0f, 0.5f, -3.5f, 6.0f);
            this.GLrect(2.0f, -2.5f, 6.0f, 3.0f, -3.5f, 6.0f);
        }
        this.gl.glPopMatrix();
    }

    public void GLframe(float f, float f2, float f3, float f4, float f5, float f6) {
        this.gl.glLineWidth(3.0f);
        this.gl.glBegin(3);
        this.gl.glVertex3f(f, f2, f3);
        this.gl.glVertex3f(f4, f2, f3);
        this.gl.glVertex3f(f4, f5, f6);
        this.gl.glVertex3f(f, f5, f6);
        this.gl.glVertex3f(f, f2, f3);
        this.gl.glEnd();
    }

    public void shoot(int n) {
        if (this.millis() - this.lastShot > this.shotDelay) {
            this.lastShot = this.millis();
            float f = -this.shipA * ((float)Math.PI * 2) / 360.0f;
            this.shots.add(new shot(f));
            if (n == 3) {
                this.play(2);
                this.shots.add(new shot(f - 0.3926991f));
                this.shots.add(new shot(f + 0.3926991f));
            } else {
                this.play(1);
            }
        }
    }

    public void updateShots() {
        int n = 0;
        while (n < this.shots.size()) {
            ((shot)this.shots.get(n)).update();
            ++n;
        }
        n = 0;
        while (n < this.bursts.size()) {
            ((burst)this.bursts.get(n)).update();
            ++n;
        }
    }

    public float chaseY(float f, float f2, float f3) {
        return f + f3 * CrystalCave.sin((float)f2);
    }

    public float chaseX(float f, float f2, float f3) {
        return f + f3 * CrystalCave.cos((float)f2);
    }

    public void getSlices() {
        int n;
        this.getNoiseMap();
        int n2 = 0;
        while (n2 < this.mapH) {
            n = 0;
            while (n < this.mapW) {
                if (this.grids[n][n2] == 0.0f) {
                    this.grids[n][n2] = this.random(0.5f, 0.6f);
                }
                float[] fArray = this.grids[n];
                int n3 = n2;
                fArray[n3] = fArray[n3] + this.noiseMap[n][n2] * this.noiseScalar;
                ++n;
            }
            ++n2;
        }
        this.slices = new slice[this.mapH];
        n2 = 0;
        while (n2 < this.mapH) {
            this.slices[n2] = new slice(n2);
            this.slices[n2].addPoint(0, this.maxR);
            this.slices[n2].addPoint(-50, -20.0f);
            n = 0;
            while (n < this.mapW) {
                this.slices[n2].addPoint(n, this.grids[n][n2]);
                this.slices[n2].addPoint(n, -20.0f);
                ++n;
            }
            this.slices[n2].addPoint(this.mapW + 50, this.maxR);
            this.slices[n2].addPoint(this.mapW + 50, -20.0f);
            ++n2;
        }
        this.slicedUp = true;
    }

    public void drawCircle(int n, int n2, int n3, int n4) {
        int n5 = n2 - n3;
        while (n5 <= n2 + n3) {
            int n6 = n - n3;
            while (n6 <= n + n3) {
                if (CrystalCave.dist((float)n, (float)n2, (float)n6, (float)n5) <= (float)n3) {
                    this.grids[CrystalCave.constrain((int)n6, (int)0, (int)(this.mapW - 1))][CrystalCave.constrain((int)n5, (int)0, (int)(this.mapH - 1))] = CrystalCave.max((float)((float)n3 - (CrystalCave.dist((float)n, (float)n2, (float)n6, (float)n5) + this.random(-this.noiseVal, this.noiseVal))), (float)this.grids[CrystalCave.constrain((int)n6, (int)0, (int)(this.mapW - 1))][CrystalCave.constrain((int)n5, (int)0, (int)(this.mapH - 1))]);
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void write(String string, float f, float f2, float f3, int n) {
        string = string.toLowerCase();
        this.gl.glPushMatrix();
        this.noStroke();
        this.gl.glTranslatef(f, f2, 0.0f);
        this.gl.glScalef(f3, f3, f3);
        if (n == 0) {
            this.gl.glTranslatef(0.0f, -2.5f, 0.0f);
        } else {
            float f4 = this.textLength(string);
            if (n == 2) {
                this.gl.glTranslatef(-f4, -2.5f, 0.0f);
            } else if (n == 1) {
                this.gl.glTranslatef(-f4 / 2.0f, -2.5f, 0.0f);
            }
        }
        int n2 = 0;
        while (n2 < string.length()) {
            this.drawLetter(string.charAt(n2));
            ++n2;
        }
        this.gl.glPopMatrix();
    }

    public void updateMessages() {
        int n = 0;
        while (n < this.messages.size()) {
            ((message)this.messages.get(n)).update();
            ++n;
        }
    }

    public void showMessage(String string, boolean bl) {
        if (bl) {
            this.messages.clear();
        }
        this.messages.add(new message(0.0f, 0.0f, string));
    }

    public float textLength(String string) {
        int n = this.count(string, "l1.,:'!");
        int n2 = this.count(string, "itTI ()[]");
        int n3 = this.count(string, "MWmw");
        return n * 3 + n2 * 4 + n3 * 6 + (string.length() - (n + n2 + n3)) * 5 + 1;
    }

    public int count(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            int n3 = 0;
            while (n3 < string2.length()) {
                if (c == string2.charAt(n3)) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public void drawLetter(char c) {
        float f = 5.0f;
        switch (c) {
            case 'a': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 5.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                break;
            }
            case 'b': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 2.0f, 1.0f);
                this.GLrect(2.0f, 0.0f, 3.0f, 2.0f);
                this.GLrect(1.0f, 2.0f, 4.0f, 3.0f);
                this.GLrect(3.0f, 3.0f, 4.0f, 4.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case 'c': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case 'd': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 4.0f);
                this.GLrect(1.0f, 4.0f, 3.0f, 5.0f);
                break;
            }
            case 'e': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                this.GLrect(1.0f, 2.0f, 4.0f, 3.0f);
                this.GLrect(1.0f, 0.0f, 4.0f, 1.0f);
                break;
            }
            case 'f': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(1.0f, 2.0f, 4.0f, 3.0f);
                break;
            }
            case 'g': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 3.0f, 5.0f);
                this.GLrect(3.0f, 2.0f, 4.0f, 5.0f);
                this.GLrect(2.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(1.0f, 0.0f, 4.0f, 1.0f);
                break;
            }
            case 'h': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 5.0f);
                break;
            }
            case 'i': {
                this.GLrect(0.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(1.0f, 1.0f, 2.0f, 4.0f);
                this.GLrect(0.0f, 4.0f, 3.0f, 5.0f);
                f = 4.0f;
                break;
            }
            case 'j': {
                this.GLrect(0.0f, 3.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 4.0f);
                break;
            }
            case 'k': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 2.0f);
                this.GLrect(3.0f, 3.0f, 4.0f, 5.0f);
                break;
            }
            case 'l': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case 'm': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 5.0f, 1.0f);
                this.GLrect(4.0f, 1.0f, 5.0f, 5.0f);
                this.GLrect(2.0f, 1.0f, 3.0f, 5.0f);
                f = 6.0f;
                break;
            }
            case 'n': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 1.0f, 2.0f, 2.0f);
                this.GLrect(2.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 5.0f);
                break;
            }
            case 'o': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 3.0f, 5.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 3.0f, 1.0f);
                break;
            }
            case 'p': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 3.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                break;
            }
            case 'q': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 3.0f, 5.0f);
                this.GLrect(2.0f, 3.0f, 3.0f, 4.0f);
                break;
            }
            case 'r': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 3.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(2.0f, 3.0f, 3.0f, 5.0f);
                this.GLrect(3.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case 's': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(0.0f, 1.0f, 1.0f, 2.0f);
                this.GLrect(0.0f, 2.0f, 4.0f, 3.0f);
                this.GLrect(3.0f, 3.0f, 4.0f, 4.0f);
                this.GLrect(0.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case 't': {
                this.GLrect(0.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(1.0f, 1.0f, 2.0f, 5.0f);
                f = 4.0f;
                break;
            }
            case 'u': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 3.0f, 5.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 5.0f);
                break;
            }
            case 'v': {
                this.GLrect(0.0f, 0.0f, 1.0f, 4.0f);
                this.GLrect(1.0f, 4.0f, 2.0f, 5.0f);
                this.GLrect(2.0f, 2.0f, 3.0f, 4.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 2.0f);
                break;
            }
            case 'w': {
                this.GLrect(0.0f, 0.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                this.GLrect(4.0f, 0.0f, 5.0f, 5.0f);
                this.GLrect(2.0f, 0.0f, 3.0f, 4.0f);
                f = 6.0f;
                break;
            }
            case 'x': {
                this.GLrect(0.0f, 0.0f, 1.0f, 2.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 2.0f);
                this.GLrect(3.0f, 3.0f, 4.0f, 5.0f);
                this.GLrect(0.0f, 3.0f, 1.0f, 5.0f);
                break;
            }
            case 'y': {
                this.GLrect(0.0f, 0.0f, 1.0f, 2.0f);
                this.GLrect(0.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 5.0f);
                this.GLrect(0.0f, 4.0f, 3.0f, 5.0f);
                break;
            }
            case 'z': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 2.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(0.0f, 3.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case '1': {
                this.GLrect(0.0f, 0.0f, 1.0f, 1.0f);
                this.GLrect(1.0f, 0.0f, 2.0f, 5.0f);
                f = 3.0f;
                break;
            }
            case '2': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 2.0f);
                this.GLrect(0.0f, 2.0f, 4.0f, 3.0f);
                this.GLrect(0.0f, 3.0f, 1.0f, 4.0f);
                this.GLrect(0.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case '3': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 4.0f);
                this.GLrect(0.0f, 4.0f, 4.0f, 5.0f);
                this.GLrect(0.0f, 2.0f, 3.0f, 3.0f);
                break;
            }
            case '4': {
                this.GLrect(0.0f, 0.0f, 1.0f, 3.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 5.0f);
                break;
            }
            case '5': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(0.0f, 1.0f, 1.0f, 2.0f);
                this.GLrect(0.0f, 2.0f, 4.0f, 3.0f);
                this.GLrect(3.0f, 3.0f, 4.0f, 4.0f);
                this.GLrect(0.0f, 4.0f, 4.0f, 5.0f);
                break;
            }
            case '6': {
                this.GLrect(0.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(0.0f, 1.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 4.0f, 5.0f);
                this.GLrect(3.0f, 2.0f, 4.0f, 4.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                break;
            }
            case '7': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 2.0f);
                this.GLrect(2.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(1.0f, 3.0f, 2.0f, 5.0f);
                break;
            }
            case '8': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(0.0f, 1.0f, 1.0f, 4.0f);
                this.GLrect(0.0f, 4.0f, 4.0f, 5.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 4.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                break;
            }
            case '9': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(0.0f, 1.0f, 1.0f, 2.0f);
                this.GLrect(0.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 3.0f, 5.0f);
                break;
            }
            case '0': {
                this.GLrect(0.0f, 0.0f, 4.0f, 1.0f);
                this.GLrect(0.0f, 4.0f, 4.0f, 5.0f);
                this.GLrect(0.0f, 1.0f, 1.0f, 4.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 4.0f);
                break;
            }
            case '.': {
                this.GLrect(1.0f, 4.0f, 2.0f, 5.0f);
                f = 3.0f;
                break;
            }
            case '!': {
                this.GLrect(1.0f, 0.0f, 2.0f, 3.0f);
                this.GLrect(1.0f, 4.0f, 2.0f, 5.0f);
                f = 3.0f;
                break;
            }
            case ',': {
                this.GLrect(1.0f, 3.0f, 2.0f, 5.0f);
                this.GLrect(0.0f, 5.0f, 1.0f, 6.0f);
                f = 3.0f;
                break;
            }
            case '-': {
                this.GLrect(0.0f, 2.0f, 4.0f, 3.0f);
                break;
            }
            case '=': {
                this.GLrect(0.0f, 1.0f, 4.0f, 2.0f);
                this.GLrect(0.0f, 3.0f, 4.0f, 4.0f);
                break;
            }
            case ':': {
                this.GLrect(1.0f, 1.0f, 2.0f, 2.0f);
                this.GLrect(1.0f, 3.0f, 2.0f, 4.0f);
                f = 3.0f;
                break;
            }
            case ' ': {
                f = 4.0f;
                break;
            }
            case '\'': {
                this.GLrect(1.0f, 0.0f, 2.0f, 2.0f);
                f = 3.0f;
                break;
            }
            case '/': {
                this.GLrect(0.0f, 4.0f, 1.0f, 5.0f);
                this.GLrect(1.0f, 2.0f, 2.0f, 4.0f);
                this.GLrect(2.0f, 1.0f, 3.0f, 3.0f);
                this.GLrect(3.0f, 0.0f, 4.0f, 1.0f);
                break;
            }
            case '(': {
                f = 4.0f;
                this.GLrect(2.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(1.0f, 1.0f, 2.0f, 4.0f);
                this.GLrect(2.0f, 4.0f, 3.0f, 5.0f);
                break;
            }
            case ')': {
                f = 4.0f;
                this.GLrect(1.0f, 0.0f, 2.0f, 1.0f);
                this.GLrect(2.0f, 1.0f, 3.0f, 4.0f);
                this.GLrect(1.0f, 4.0f, 2.0f, 5.0f);
                break;
            }
            case '[': {
                f = 4.0f;
                this.GLrect(2.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(1.0f, 0.0f, 2.0f, 5.0f);
                this.GLrect(2.0f, 4.0f, 3.0f, 5.0f);
                break;
            }
            case ']': {
                f = 4.0f;
                this.GLrect(1.0f, 0.0f, 2.0f, 1.0f);
                this.GLrect(2.0f, 0.0f, 3.0f, 5.0f);
                this.GLrect(1.0f, 4.0f, 2.0f, 5.0f);
                break;
            }
            case '?': {
                this.GLrect(0.0f, 0.0f, 3.0f, 1.0f);
                this.GLrect(3.0f, 1.0f, 4.0f, 2.0f);
                this.GLrect(1.0f, 2.0f, 3.0f, 3.0f);
                this.GLrect(1.0f, 4.0f, 2.0f, 5.0f);
            }
        }
        this.gl.glTranslatef(f, 0.0f, 0.0f);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#c0c0c0", "CrystalCave"});
    }

    class burst {
        float xPos;
        float yPos;
        float zPos;
        float x;
        float y;
        float s;
        float a;
        int timer;

        burst(float f, float f2, float f3, int n, float f4) {
            this.a = CrystalCave.this.random((float)Math.PI * 2);
            this.x = 0.0f;
            this.y = 0.0f;
            this.xPos = f;
            this.yPos = f2;
            this.zPos = f3;
            this.s = CrystalCave.this.random(f4, f4 * 3.0f);
            this.timer = n;
        }

        public void update() {
            this.x = CrystalCave.this.chaseX(this.x, this.a, this.s);
            this.y = CrystalCave.this.chaseY(this.y, this.a, this.s);
            CrystalCave.this.gl.glPushMatrix();
            CrystalCave.this.gl.glTranslatef(this.xPos, this.yPos, this.zPos);
            CrystalCave.this.gl.glRotatef(CrystalCave.this.tilt * 360.0f / ((float)Math.PI * 2), -1.0f, 0.0f, 0.0f);
            CrystalCave.this.gl.glRotatef(this.a * 360.0f / ((float)Math.PI * 2), 0.0f, 0.0f, 1.0f);
            CrystalCave.this.gl.glTranslatef(this.x, this.y, 0.0f);
            CrystalCave.this.gl.glColor4f(1.0f, 1.0f, 1.0f, 0.45f);
            CrystalCave.this.GLrect(-1.0f, -1.0f, 1.0f, 1.0f);
            CrystalCave.this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            CrystalCave.this.GLrect(-0.5f, -0.5f, 0.5f, 0.5f);
            CrystalCave.this.gl.glPopMatrix();
            --this.timer;
            if (this.timer <= 0) {
                CrystalCave.this.bursts.remove(this);
            }
        }
    }

    class enemy {
        float spin;
        float x;
        float y;
        float z;
        float distY;
        int t;
        int hit = -1;
        float[] burstA = new float[20];
        float[] burstS = new float[20];

        enemy(int n, float f, float f2, float f3) {
            this.t = n;
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.spin = CrystalCave.this.random(360.0f);
            this.distY = 0.0f;
            int n2 = 0;
            while (n2 < this.burstA.length) {
                this.burstA[n2] = CrystalCave.this.random((float)Math.PI * 2);
                this.burstS[n2] = CrystalCave.this.random(-2.0f, 2.0f);
                ++n2;
            }
        }

        public void update() {
            if (this.y > (float)CrystalCave.this.mapH) {
                this.y -= (float)CrystalCave.this.mapH;
            }
            switch (this.t) {
                case 0: {
                    float f;
                    float f2;
                    int n;
                    this.spin = (this.spin + 3.0f) % 360.0f;
                    this.distY = CrystalCave.this.viewY - this.y;
                    if (!(this.distY < (float)CrystalCave.this.viewDist * 1.2f)) break;
                    if (this.hit == -1) {
                        n = 0;
                        f2 = this.y;
                        f = this.x;
                        float f3 = this.z;
                        while (n < 100 && true) {
                            this.y = f2 - CrystalCave.this.flySpeed / 2.0f;
                            this.x = f + CrystalCave.this.random(-0.5f, 0.5f);
                            this.z = f3 + CrystalCave.this.random(-0.5f, 0.5f);
                            if (!CrystalCave.this.collisionMap[CrystalCave.constrain((int)CrystalCave.round((float)this.x), (int)0, (int)(CrystalCave.this.mapW - 1))][CrystalCave.constrain((int)CrystalCave.round((float)this.y), (int)0, (int)(CrystalCave.this.mapH - 1))][CrystalCave.constrain((int)CrystalCave.abs((int)CrystalCave.round((float)this.z)), (int)0, (int)(CrystalCave.this.mapZ - 1))]) {
                                // empty if block
                            }
                            ++n;
                        }
                        if (CrystalCave.this.collisionMap[CrystalCave.constrain((int)CrystalCave.round((float)this.x), (int)0, (int)(CrystalCave.this.mapW - 1))][CrystalCave.constrain((int)CrystalCave.round((float)this.y), (int)0, (int)(CrystalCave.this.mapH - 1))][CrystalCave.constrain((int)CrystalCave.abs((int)CrystalCave.round((float)this.z)), (int)0, (int)(CrystalCave.this.mapZ - 1))]) {
                            this.hit = 20;
                        }
                        if (CrystalCave.abs((float)(CrystalCave.this.viewX - this.x)) <= 4.0f && CrystalCave.abs((float)(CrystalCave.this.viewY + (float)CrystalCave.this.collisionDist - this.y)) <= 4.0f && CrystalCave.abs((float)(CrystalCave.this.viewZ - this.z)) <= 5.0f) {
                            CrystalCave.this.shipAsplode();
                            this.hit = 20;
                        }
                    }
                    CrystalCave.this.gl.glPushMatrix();
                    CrystalCave.this.gl.glTranslatef(this.x * CrystalCave.this.sliceScalar * CrystalCave.this.widthScalar, (this.y - CrystalCave.this.viewY) * CrystalCave.this.sliceScalar * CrystalCave.this.depthScalar, this.z);
                    CrystalCave.this.gl.glRotatef(CrystalCave.this.tilt * 360.0f / ((float)Math.PI * 2), -1.0f, 0.0f, 0.0f);
                    if (this.hit == -1) {
                        CrystalCave.this.gl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f - this.distY / (float)(CrystalCave.this.viewDist * 2));
                        CrystalCave.this.GLdiamond(0.0f, 0.0f, 3.0f);
                        CrystalCave.this.gl.glRotatef(CrystalCave.this.random(360.0f), 0.0f, 0.0f, 1.0f);
                        CrystalCave.this.gl.glColor4f(1.0f, 0.0f, 0.0f, 0.25f);
                        CrystalCave.this.GLdiamond(0.0f, 0.0f, CrystalCave.this.random(3.0f, 5.0f));
                    } else {
                        n = 0;
                        while (n < 20) {
                            f2 = CrystalCave.this.chaseX(0.0f, this.burstA[n], (float)(20 - this.hit) * this.burstS[n]);
                            f = CrystalCave.this.chaseY(0.0f, this.burstA[n], (float)(20 - this.hit) * this.burstS[n]);
                            CrystalCave.this.gl.glColor4f(1.0f, 0.0f, 0.0f, 0.45f);
                            CrystalCave.this.GLdiamond(f2, f, 2.0f);
                            CrystalCave.this.gl.glColor3f(1.0f, 0.0f, 0.0f);
                            CrystalCave.this.GLdiamond(f2, f, 1.0f);
                            ++n;
                        }
                        this.hit = CrystalCave.constrain((int)(this.hit - 1), (int)0, (int)this.hit);
                    }
                    CrystalCave.this.gl.glPopMatrix();
                    if (this.hit != 0) break;
                    CrystalCave.this.enemies.remove(this);
                }
            }
        }

        public boolean shotTest(int n, int n2, int n3) {
            return this.distY <= CrystalCave.this.viewY && CrystalCave.abs((float)((float)n - this.x)) <= 6.0f && CrystalCave.abs((float)((float)n2 - this.y)) <= 6.0f && CrystalCave.abs((float)((float)n3 - this.z)) <= 6.0f;
        }

        public void shotHit() {
            if (this.hit == -1) {
                this.hit = 20;
            }
        }
    }

    class hiScore {
        int num;
        String name;

        hiScore(int n, String string) {
            this.num = n;
            this.name = string;
        }

        public String writeLine() {
            return String.valueOf(this.num) + " - " + this.name;
        }
    }

    class message {
        float x;
        float y;
        float l;
        float t;
        String c;

        message(float f, float f2, String string) {
            this.c = string;
            this.l = CrystalCave.this.textLength(this.c) * 3.0f;
            this.t = 1.0f;
            this.x = f;
            this.y = f2;
        }

        public void update() {
            CrystalCave.this.gl.glColor4f(1.0f, 1.0f, 1.0f, this.t);
            CrystalCave.this.write(this.c, this.x, this.y, 3.0f, 1);
            this.t -= 0.015f;
            if (this.t <= 0.0f) {
                CrystalCave.this.messages.remove(this);
            }
        }
    }

    class powerup {
        float spin;
        float x;
        float y;
        float z;
        float distY;
        int t;
        int grabbed = -1;

        powerup(int n, float f, float f2, float f3) {
            this.t = n;
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.spin = CrystalCave.this.random(360.0f);
            this.distY = 0.0f;
        }

        public void update() {
            switch (this.t) {
                case 0: {
                    this.spin = (this.spin + 3.0f) % 360.0f;
                    this.distY = CrystalCave.this.viewY - this.y;
                    if (!(this.distY < (float)CrystalCave.this.viewDist * 1.2f)) break;
                    if (this.grabbed == -1 && CrystalCave.abs((float)(CrystalCave.this.viewX - this.x)) <= 4.0f && CrystalCave.abs((float)(CrystalCave.this.viewY + (float)CrystalCave.this.collisionDist - this.y)) <= 4.0f && CrystalCave.abs((float)(CrystalCave.this.viewZ - this.z)) <= 5.0f) {
                        CrystalCave.this.play(3);
                        CrystalCave.this.play(6);
                        ++CrystalCave.this.crystals;
                        this.grabbed = 20;
                    }
                    CrystalCave.this.gl.glPushMatrix();
                    CrystalCave.this.gl.glTranslatef(this.x * CrystalCave.this.sliceScalar * CrystalCave.this.widthScalar, (this.y - CrystalCave.this.viewY) * CrystalCave.this.sliceScalar * CrystalCave.this.depthScalar, this.z);
                    CrystalCave.this.gl.glRotatef(CrystalCave.this.tilt * 360.0f / ((float)Math.PI * 2), -1.0f, 0.0f, 0.0f);
                    if (this.grabbed == -1) {
                        CrystalCave.this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f - this.distY / (float)(CrystalCave.this.viewDist * 2));
                        CrystalCave.this.GLdiamond(0.0f, 0.0f, 3.0f);
                        CrystalCave.this.gl.glRotatef(this.spin, 0.0f, 1.0f, 0.0f);
                        CrystalCave.this.gl.glColor4f(1.0f, 1.0f, 1.0f, 0.25f);
                        CrystalCave.this.glu.gluSphere(CrystalCave.this.quadric, 6.0, 4, 2);
                    } else {
                        int n = 0;
                        while (n < this.grabbed) {
                            float f = CrystalCave.this.random(-5.0f, 5.0f) * CrystalCave.sin((float)CrystalCave.this.random((float)Math.PI * 2));
                            float f2 = CrystalCave.this.random(-5.0f, 5.0f) * CrystalCave.cos((float)CrystalCave.this.random((float)Math.PI * 2));
                            CrystalCave.this.gl.glColor4f(1.0f, 1.0f, 1.0f, 0.45f);
                            CrystalCave.this.GLdiamond(f, f2, 2.0f);
                            CrystalCave.this.gl.glColor3f(0.9f, 0.95f, 1.0f);
                            CrystalCave.this.GLdiamond(f, f2, 1.0f);
                            ++n;
                        }
                        this.grabbed = CrystalCave.constrain((int)(this.grabbed - 2), (int)0, (int)this.grabbed);
                    }
                    CrystalCave.this.gl.glPopMatrix();
                    if (this.grabbed != 0) break;
                    CrystalCave.this.powerups.remove(this);
                    break;
                }
            }
        }

        public boolean shotTest(int n, int n2, int n3) {
            return this.distY <= CrystalCave.this.viewY && CrystalCave.abs((float)((float)n - this.x)) <= 5.0f && CrystalCave.abs((float)((float)n2 - this.y)) <= 5.0f && CrystalCave.abs((float)((float)n3 - this.z)) <= 5.0f;
        }

        public void shotHit() {
            if (this.grabbed == -1) {
                this.grabbed = 0;
            }
        }
    }

    class shipChunk {
        float x;
        float y;
        float sx;
        float sy;
        float sz;
        float a;
        float s;
        float spinX;
        float spinY;
        float spinZ;
        float x1;
        float x2;
        float x3;
        float y1;
        float y2;
        float y3;
        int t;

        shipChunk(int n) {
            this.t = n;
            this.x = 0.0f;
            this.y = 0.0f;
            this.a = CrystalCave.this.random((float)Math.PI * 2);
            this.s = CrystalCave.this.random(CrystalCave.this.asplodeSpeed / 2.0f, CrystalCave.this.asplodeSpeed);
            this.sx = CrystalCave.this.random(360.0f);
            this.sy = CrystalCave.this.random(360.0f);
            this.sz = CrystalCave.this.random(360.0f);
            this.spinX = CrystalCave.this.random(-CrystalCave.this.chunkSpin, CrystalCave.this.chunkSpin);
            this.spinY = CrystalCave.this.random(-CrystalCave.this.chunkSpin, CrystalCave.this.chunkSpin);
            this.spinZ = CrystalCave.this.random(-CrystalCave.this.chunkSpin, CrystalCave.this.chunkSpin);
            this.x1 = CrystalCave.this.random(-CrystalCave.this.shipChunkSize, CrystalCave.this.shipChunkSize);
            this.x2 = CrystalCave.this.random(-CrystalCave.this.shipChunkSize, CrystalCave.this.shipChunkSize);
            this.x3 = CrystalCave.this.random(-CrystalCave.this.shipChunkSize, CrystalCave.this.shipChunkSize);
            this.y1 = CrystalCave.this.random(-CrystalCave.this.shipChunkSize, CrystalCave.this.shipChunkSize);
            this.y2 = CrystalCave.this.random(-CrystalCave.this.shipChunkSize, CrystalCave.this.shipChunkSize);
            this.y3 = CrystalCave.this.random(-CrystalCave.this.shipChunkSize, CrystalCave.this.shipChunkSize);
        }

        public void update() {
            this.x = CrystalCave.this.chaseX(this.x, this.a, this.s);
            this.y = CrystalCave.this.chaseY(this.y, this.a, this.s);
            this.sx = (this.sx + this.spinX) % 360.0f;
            this.sy = (this.sy + this.spinY) % 360.0f;
            this.sz = (this.sz + this.spinZ) % 360.0f;
            CrystalCave.this.gl.glPushMatrix();
            CrystalCave.this.gl.glTranslatef(this.x, this.y, 0.0f);
            CrystalCave.this.gl.glRotatef(this.sx, 1.0f, 0.0f, 0.0f);
            CrystalCave.this.gl.glRotatef(this.sy, 0.0f, 1.0f, 0.0f);
            CrystalCave.this.gl.glRotatef(this.sz, 0.0f, 0.0f, 1.0f);
            switch (this.t) {
                case 0: {
                    CrystalCave.this.gl.glColor3f(0.0f, 0.5f, 1.0f);
                    CrystalCave.this.GLrect(-1.0f, -1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    CrystalCave.this.gl.glColor3f(0.6f, 0.6f, 0.6f);
                    CrystalCave.this.GLtriangle(this.x1, this.y1, 0.0f, this.x2, this.y2, 0.0f, this.x3, this.y3, 0.0f);
                    break;
                }
                case 2: {
                    CrystalCave.this.gl.glColor3f(0.4f, 0.4f, 0.4f);
                    CrystalCave.this.GLtriangle(this.x1, this.y1, 0.0f, this.x2, this.y2, 0.0f, this.x3, this.y3, 0.0f);
                }
            }
            CrystalCave.this.gl.glPopMatrix();
        }
    }

    class shot {
        float x;
        float y;
        float z;
        float s;
        float a;
        float za;
        int timer;

        shot(float f) {
            this.x = CrystalCave.this.viewX * CrystalCave.this.sliceScalar * CrystalCave.this.widthScalar;
            this.y = CrystalCave.this.viewY;
            this.z = CrystalCave.this.viewZ;
            this.s = CrystalCave.this.shotSpeed + CrystalCave.this.flySpeed;
            this.a = f - 1.5707964f;
            this.za = -CrystalCave.this.shipZA;
            this.timer = CrystalCave.this.shotDist;
        }

        public void update() {
            this.x = CrystalCave.this.chaseX(this.x, this.a, this.s);
            this.y = CrystalCave.this.chaseY(this.y, this.a, this.s);
            this.z = CrystalCave.this.chaseY(this.z, this.za, this.s);
            CrystalCave.this.gl.glPushMatrix();
            CrystalCave.this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            CrystalCave.this.gl.glTranslatef(this.x, (this.y - CrystalCave.this.viewY) * CrystalCave.this.sliceScalar * CrystalCave.this.depthScalar, this.z);
            CrystalCave.this.gl.glRotatef(CrystalCave.this.tilt * 360.0f / ((float)Math.PI * 2), -1.0f, 0.0f, 0.0f);
            CrystalCave.this.gl.glRotatef((float)(this.timer * 20), 0.0f, 0.0f, 1.0f);
            CrystalCave.this.gl.glColor4f(1.0f, 1.0f, 1.0f, 0.45f);
            CrystalCave.this.GLrect(-2.0f, -2.0f, 2.0f, 2.0f);
            CrystalCave.this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            CrystalCave.this.GLrect(-1.0f, -1.0f, 1.0f, 1.0f);
            CrystalCave.this.gl.glPopMatrix();
            --this.timer;
            if (this.timer < 0) {
                CrystalCave.this.shots.remove(this);
            } else {
                int n;
                int n2 = 0;
                while (n2 < CrystalCave.this.enemies.size()) {
                    if (((enemy)CrystalCave.this.enemies.get(n2)).shotTest(CrystalCave.round((float)(this.x / (CrystalCave.this.sliceScalar * CrystalCave.this.widthScalar))), CrystalCave.round((float)this.y), CrystalCave.round((float)CrystalCave.this.viewZ))) {
                        CrystalCave.this.play(4);
                        n = 0;
                        while (n < 10) {
                            CrystalCave.this.bursts.add(new burst(this.x, (this.y - CrystalCave.this.viewY) * CrystalCave.this.sliceScalar * CrystalCave.this.depthScalar, this.z, 10, 0.5f));
                            ++n;
                        }
                        ((enemy)CrystalCave.this.enemies.get(n2)).shotHit();
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < CrystalCave.this.powerups.size()) {
                    if (((powerup)CrystalCave.this.powerups.get(n2)).shotTest(CrystalCave.round((float)(this.x / (CrystalCave.this.sliceScalar * CrystalCave.this.widthScalar))), CrystalCave.round((float)this.y), CrystalCave.round((float)CrystalCave.this.viewZ))) {
                        CrystalCave.this.play(4);
                        n = 0;
                        while (n < 25) {
                            CrystalCave.this.bursts.add(new burst(this.x, (this.y - CrystalCave.this.viewY) * CrystalCave.this.sliceScalar * CrystalCave.this.depthScalar, this.z, 10, 0.5f));
                            ++n;
                        }
                        ((powerup)CrystalCave.this.powerups.get(n2)).shotHit();
                    }
                    ++n2;
                }
                if (CrystalCave.this.collisionMap[CrystalCave.constrain((int)CrystalCave.round((float)(this.x / (CrystalCave.this.sliceScalar * CrystalCave.this.widthScalar))), (int)0, (int)(CrystalCave.this.mapW - 1))][CrystalCave.constrain((int)CrystalCave.round((float)(this.y + CrystalCave.this.shotSpeed)), (int)0, (int)(CrystalCave.this.mapH - 1))][CrystalCave.abs((int)CrystalCave.round((float)CrystalCave.this.viewZ))]) {
                    CrystalCave.this.play(4);
                    n2 = 0;
                    while (n2 < 10) {
                        CrystalCave.this.bursts.add(new burst(this.x, (this.y - CrystalCave.this.viewY) * CrystalCave.this.sliceScalar * CrystalCave.this.depthScalar, this.z, 10, 0.5f));
                        ++n2;
                    }
                    CrystalCave.this.shots.remove(this);
                }
            }
        }
    }

    class slice {
        PVector[] points;
        PVector[] topPoints;
        int x;
        int y;
        int pointCounter;
        int backCounter;
        float fillC;

        slice(int n) {
            this.points = new PVector[CrystalCave.this.mapW * 2 + 4];
            this.y = n;
            this.pointCounter = 0;
            this.backCounter = this.points.length - 1;
        }

        public void addPoint(int n, float f) {
            this.points[this.pointCounter] = new PVector((float)n * CrystalCave.this.sliceScalar * CrystalCave.this.widthScalar, f * CrystalCave.this.sliceScalar * CrystalCave.this.heightScalar);
            int n2 = 0;
            while (n2 < CrystalCave.this.mapZ) {
                if (n >= 0 && n < CrystalCave.this.mapW && this.points[this.pointCounter].y >= (float)(CrystalCave.this.mapZ - n2)) {
                    CrystalCave.this.collisionMap[n][this.y][n2] = true;
                }
                ++n2;
            }
            ++this.pointCounter;
        }
    }
}

